<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Obtener datos del cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1])) {
        throw new Exception("Los Parámetros son obligatorios.");
    }

    // Preparar consulta en PostgreSQL
    $sql = "SELECT nombre FROM almacenes WHERE empresa_id = :empresaid And nombre = :nombre LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresaid', $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':nombre', $datos[1], PDO::PARAM_STR);
    $stmt->execute();

    // Obtener resultados
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Cerrar statement
    $stmt = null;

    // Imprimir respuesta en JSON
    print_json($rows);

} catch (Exception $e) {
    error_response($e->getMessage());
}

// Función para devolver JSON válido
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
}

// Función para manejo de errores
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>