<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    if (count($datos) < 5) {
        throw new Exception("Parámetros incompletos.");
    }

    // Ejecutar la función de PostgreSQL que devuelve nRegistros
    $stmt = $conn->prepare("SELECT * FROM apertura_caja(:empresa_id, :sucursal_id, :usuario_apertura, :fecha_apertura, :estado)");

    $stmt->bindParam(':empresa_id',       $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id',      $datos[1], PDO::PARAM_INT);
    $stmt->bindParam(':usuario_apertura', $datos[2], PDO::PARAM_STR);
    $stmt->bindParam(':fecha_apertura',   $datos[3], PDO::PARAM_STR);
    $stmt->bindParam(':estado',           $datos[4], PDO::PARAM_INT);

    $stmt->execute();
    $mensaje = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($mensaje && $mensaje['nregistros'] > 0) {
        $resultado = [
            'ESTADO'    => "1",
            'REGISTROS' => $mensaje['nregistros'],
            'MENSAJE'   => "LA INFORMACION SE REGISTRO CORRECTAMENTE"
        ];
    } else {
        $resultado = [
            'ESTADO'    => "0",
            'REGISTROS' => "0",
            'MENSAJE'   => "NO SE REGISTRÓ NINGUNA INFORMACIÓN"
        ];
    }

} catch (Exception $e) {
    $resultado = [
        'MENSAJE' => "ERROR: " . $e->getMessage(),
        'ESTADO'  => "0",
        'ID'      => "0"
    ];
}

echo json_encode($resultado, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>
