<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// ✅ Validación del token
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros incompletos. Se espera: turno_id, empleado_id, caja_id");
    }

    $turno_id = $datos[0];
    $empleado_id = $datos[1];
    $caja_id = $datos[2];

    // Llamamos la función directamente
    $stmt = $conn->prepare("SELECT public.saldo_caja_turno(:turno_id, :empleado_id, :caja_id) AS saldo_final");
    $stmt->bindParam(':turno_id', $turno_id, PDO::PARAM_INT);
    $stmt->bindParam(':empleado_id', $empleado_id, PDO::PARAM_INT);
    $stmt->bindParam(':caja_id', $caja_id, PDO::PARAM_INT);

    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

    echo json_encode($resultado, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}
?>
