<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    if (!isset($datos[0], $datos[1], $datos[2], $datos[3], $datos[4])) {
        throw new Exception("Parámetros incompletos.");
    }

    $stmt = $conn->prepare("
        SELECT COALESCE(SUM(ingreso - egreso), 0) AS saldo_cierre
        FROM detcaja
        WHERE empresa_id = :empresa_id
          AND sucursal_id = :sucursal_id
          AND cuenta_id = :cuenta_id
          AND fecha_operacion = :fecha_operacion
          AND anulado = :anulado
    ");

    $stmt->bindParam(':empresa_id',       $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id',      $datos[1], PDO::PARAM_INT);
    $stmt->bindParam(':cuenta_id',        $datos[2], PDO::PARAM_INT);
    $stmt->bindParam(':fecha_operacion',  $datos[3], PDO::PARAM_STR);
    $stmt->bindParam(':anulado',          $datos[4], PDO::PARAM_BOOL);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}
?>
