<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php'; 
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer cuerpo de la petición
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => "JSON inválido: " . json_last_error_msg()
    ], JSON_PRETTY_PRINT);
    exit;
}

try {
    $conn->beginTransaction();

    $sql = "SELECT eliminar_compra(?) AS resultado";
    $stmt = $conn->prepare($sql);

    $stmt->bindParam(1, $datos[0], PDO::PARAM_INT); // id_compra

    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    $resultado = $row['resultado'];

    if ($resultado > 0) {
        $conn->commit();
        echo json_encode([
            "ESTADO" => "1",
            "MENSAJE" => "Registro eliminado con éxito"
        ], JSON_PRETTY_PRINT);
    } else {
        $conn->rollBack();
        echo json_encode([
            "ESTADO" => "0",
            "MENSAJE" => "No se pudo eliminar la Compra"
        ], JSON_PRETTY_PRINT);
    }

} catch (PDOException $e) {
    $conn->rollBack();
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => "Error: " . $e->getMessage()
    ], JSON_PRETTY_PRINT);
} finally {
    $conn = null;
}
?>