<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    responder_json(['error' => 'Malformed JSON: ' . json_last_error_msg()]);
    exit;
}

try {
    $empresaId = $datos[0] ?? 0;
    $sucursalId = $datos[1] ?? 0;
    $usuarioId = $datos[2] ?? 0;
    
    $sql = "SELECT obtener_cabecera_compra(:empresa_id, :sucursal_id, :usuario_id) AS resultado";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id', $empresaId, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $sucursalId, PDO::PARAM_INT);
    $stmt->bindParam(':usuario_id', $usuarioId, PDO::PARAM_INT);
    
    $stmt->execute();

    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verificar si hay datos
    if (!$resultado) {
        error_log("⚠️ No se encontraron datos con esos filtros.");
    }

    echo $resultado['resultado'];

} catch (PDOException $e) {
    responder_json(['error' => 'Error en la consulta: ' . $e->getMessage()]);
}

function responder_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}
?>
