<?php
header("Content-Type: application/json; charset=utf-8");
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $body = file_get_contents("php://input");
    $params = json_decode($body, true);

    $proveedor_id = isset($params['proveedor_id']) ? $params['proveedor_id'] : null;
    $producto_id  = isset($params['producto_id']) ? $params['producto_id'] : null;
    $ndocumento   = isset($params['ndocumento']) ? $params['ndocumento'] : null;

    $sql = "SELECT * FROM productos_por_recoger(:proveedor_id, :producto_id, :ndocumento)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':proveedor_id', $proveedor_id, PDO::PARAM_INT);
    $stmt->bindValue(':producto_id', $producto_id, PDO::PARAM_INT);
    $stmt->bindValue(':ndocumento', $ndocumento, PDO::PARAM_STR);

    $stmt->execute();
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "estado" => "1",
        "mensaje" => "Consulta exitosa",
        "data" => $data
    ], JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    echo json_encode([
        "estado" => "0",
        "mensaje" => "Error: " . $e->getMessage()
    ]);
}