<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer datos de entrada
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 4) {
        throw new Exception("Parámetros incompletos.");
    }

    // Preparar sentencia (usa función en lugar de CALL si ya migraste a PostgreSQL)
    $sql = "SELECT * FROM Buscar_DocCompra(:empresa_id, :nserie, :ndocumento, :proveedor_id)";
    $stmt = $conn->prepare($sql);

    // Enlazar parámetros
    $stmt->bindValue(':empresa_id',   $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':nserie',       $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':ndocumento',   $datos[2], PDO::PARAM_STR);
    $stmt->bindValue(':proveedor_id', $datos[3], PDO::PARAM_INT);

    // Ejecutar y recoger resultados
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error en la consulta: ' . $e->getMessage()], JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}