<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    if (!isset($datos[0], $datos[1])) {
        throw new Exception("Parámetros incompletos.");
    }

    $stmt = $conn->prepare("SELECT * FROM verifica_proveedor(:empresa_id, :doc_identidad)");

    $stmt->bindParam(':empresa_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':doc_identidad', $datos[1], PDO::PARAM_STR);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}
?>
