<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$data = json_decode(file_get_contents('php://input'), true);

// Validación básica
if (!isset($data[0], $data[1], $data[2], $data[3], $data[4], $data[5])) {
    echo json_encode([
        "estado" => "error",
        "mensaje" => "Faltan parámetros: id, ccuenta_id, cfecha, cimporte, cempresa_id, csede_id"
    ]);
    exit();
}

$id           = (int)$data[0];
$ccuenta_id   = (int)$data[1];
$cfecha       = $data[2]; // formato yyyy-mm-dd
$cimporte     = (float)$data[3];
$cempresa_id  = (int)$data[4];
$csede_id     = (int)$data[5];

try {
    $sql = "SELECT abrir_turno(:id, :ccuenta_id, :cfecha, :cimporte, :cempresa_id, :csede_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':id'          => $id,
        ':ccuenta_id'  => $ccuenta_id,
        ':cfecha'      => $cfecha,
        ':cimporte'    => $cimporte,
        ':cempresa_id' => $cempresa_id,
        ':csede_id'    => $csede_id
    ]);

    echo json_encode(["estado" => "ok"]);
} catch (PDOException $e) {
    echo json_encode([
        "estado" => "error",
        "mensaje" => $e->getMessage()
    ]);
}
