<?php
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $datos = json_decode(file_get_contents("php://input"), true);

    if (!isset($datos[0])) {
        throw new Exception("Falta el parámetro: turno_id");
    }

    $turno_id = (int)$datos[0];

    $sql = "SELECT * FROM obtener_empleados_turno(:turno_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':turno_id', $turno_id, PDO::PARAM_INT);
    $stmt->execute();

    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "ESTADO" => "1",
        "MENSAJE" => "Consulta exitosa",
        "data" => $resultados
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => $e->getMessage()
    ]);
}
