<?php
header('Content-Type: application/json');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $input = json_decode(file_get_contents('php://input'), true);

    $id = $input['id'] ?? 0;
    $placa = trim($input['placa'] ?? '');
    $cliente_id = $input['cliente_id'] ?? 0;
    $empresa_id = $input['empresa_id'] ?? 0;
    $sucursal_id = $input['sucursal_id'] ?? 0;

    if ($placa === '' || $cliente_id <= 0 || $empresa_id <= 0 || $sucursal_id <= 0) {
        throw new Exception("Parámetros incompletos o inválidos.");
    }

    $stmt = $conn->prepare("SELECT im_placa_cliente(:id, :placa, :cliente_id, :empresa_id, :sucursal_id) AS id");
    $stmt->execute([
        ':id' => $id,
        ':placa' => $placa,
        ':cliente_id' => $cliente_id,
        ':empresa_id' => $empresa_id,
        ':sucursal_id' => $sucursal_id
    ]);

    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result && $result['id'] > 0) {
        echo json_encode([
            "ESTADO" => "OK",
            "ID" => $result['id'],
            "MENSAJE" => "Placa registrada correctamente."
        ]);
    } else {
        throw new Exception("No se pudo registrar la placa.");
    }

} catch (Exception $e) {
    echo json_encode([
        "ESTADO" => "ERROR",
        "MENSAJE" => $e->getMessage()
    ]);
}
