<?php
error_reporting(E_ALL ^ E_NOTICE);
ini_set('display_errors', 1);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $input = json_decode(file_get_contents("php://input"), true);

    $empleado_id = $input[0];
    $empresa_id  = $input[1];
    $sucursal_id = $input[2];
    $caja_id     = $input[3];

    if (!isset($empleado_id, $empresa_id, $sucursal_id, $caja_id)) {
        throw new Exception("Faltan uno o más parámetros obligatorios.");
    }

    $stmt = $conn->prepare("SELECT * FROM wincha_despachos(:empleado_id, :empresa_id, :sucursal_id, :caja_id)");
    $stmt->bindParam(':empleado_id', $empleado_id, PDO::PARAM_INT);
    $stmt->bindParam(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':caja_id', $caja_id, PDO::PARAM_INT);
    $stmt->execute();

    $resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "ESTADO" => "1",
        "MENSAJE" => "DATOS OBTENIDOS",
        "data" => $resultado
    ]);
} catch (Exception $e) {
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ]);
}
