<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 6) {
        throw new Exception("Parámetros incompletos. Se requieren 6 datos.");
    }

    // Llamada a la función PostgreSQL
    $sql = "SELECT im_docfiscal(:ccodsunat, :cnombre, :cabrev, :cclasifica, :niddocfis, :estado) AS id_docfis";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':ccodsunat', $datos[0], PDO::PARAM_STR);
    $stmt->bindValue(':cnombre', $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':cabrev', $datos[2], PDO::PARAM_STR);
    $stmt->bindValue(':cclasifica', $datos[3], PDO::PARAM_STR);
    $stmt->bindValue(':niddocfis', $datos[4], PDO::PARAM_INT);
    $stmt->bindValue(':estado', $datos[5], PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($result && isset($result['id_docfis']) && $result['id_docfis'] > 0) {
        $respuesta = [
            "ESTADO" => "1",
            "ID" => $result['id_docfis'],
            "MENSAJE" => ($datos[5] === "NUEVO")
                ? "LA INFORMACION SE GUARDO CORRECTAMENTE"
                : "LA INFORMACION SE ACTUALIZO CORRECTAMENTE"
        ];
    } else {
        $respuesta = [
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => "ERROR AL GUARDAR O ACTUALIZAR LA INFORMACION"
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
