<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 1) {
        throw new Exception("Parámetros incompletos. Se espera el ID del empleado.");
    }

    $sql = "SELECT * FROM consultar_empleado_id(:id_empleado)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':id_empleado', $datos[0], PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows ?: [], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'ERROR: ' . $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
?>
