<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

// Incluir la conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$response = [];

try {
    // Conectar con PostgreSQL usando PDO
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Validar que se recibe un ID válido
    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        throw new Exception("ID inválido");
    }

    // Preparar y ejecutar la consulta
    $sql = "SELECT * FROM empresas WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(1, $datos[0], PDO::PARAM_INT);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Verificar si hay resultados
    if (!empty($rows)) {
        $response = $rows;
    }

} catch (Exception $e) {
    error_response($e->getMessage());
}

// Cerrar la conexión
$conn = null;

// Imprimir la respuesta en formato JSON
print_json($response);

// Función para imprimir JSON
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

// Función para manejar errores
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
