<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye la conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
// Decodifica la solicitud JSON
$datos = json_decode($bodyRequest, true);

$rows = [];

try {
    // Verificar si los datos fueron proporcionados correctamente
    if (!isset($datos[0]) || !isset($datos[1])) {
        throw new Exception("Parámetros inválidos");
    }

    // Preparar la consulta (ajusta según sea función o procedimiento)
    $sql = "SELECT * FROM Buscar_Proveedor(:param1, :param2)";
    $stmt = $conn->prepare($sql);

    // Enlazar parámetros
    $stmt->bindValue(':param1', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':param2', $datos[1], PDO::PARAM_STR);

    // Ejecutar consulta
    $stmt->execute();

    // Obtener resultados
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        $rows = []; // Devolver un array vacío si no hay resultados
    }
} catch (PDOException $e) {
    error_response("Error de base de datos: " . $e->getMessage());
} catch (Exception $e) {
    error_response($e->getMessage());
}

// Cerrar la conexión a la base de datos
$conn = null;

// Enviar la respuesta en JSON
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown JSON error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
