<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye el archivo que contiene la conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validación del parámetro
    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        throw new Exception("Parámetro inválido.");
    }

    $turno_apertura_id = (int) $datos[0];

    // Preparar consulta a función PostgreSQL
    $sql = "SELECT * FROM consultar_turno_apertura_id(:turno_apertura_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':turno_apertura_id', $turno_apertura_id, PDO::PARAM_INT);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Devolver en formato JSON
    print_json($rows ?: []);

} catch (Exception $e) {
    error_response($e->getMessage());
}

// Funciones auxiliares
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al generar JSON: " . json_last_error_msg());
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
