<?php
header('Content-Type: application/json');

try {
    require_once '../conexion.php';
    include_once '../clases/TokenValidator.php';

    // Llama la validación antes de cualquier consulta
    $usuarioId = TokenValidator::validar($conn);

    $empresa_id = $_GET['empresa_id'] ?? null;
    $sucursal_id = $_GET['sucursal_id'] ?? null;
    $surtidor_turno_id = $_GET['surtidor_turno_id'] ?? null;

    if (!$empresa_id || !$sucursal_id || !$surtidor_turno_id) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    $stmt = $conn->prepare("SELECT * FROM listar_despachos_por_turno(:empresa_id, :sucursal_id, :surtidor_turno_id)");
    $stmt->execute([
        ':empresa_id' => $empresa_id,
        ':sucursal_id' => $sucursal_id,
        ':surtidor_turno_id' => $surtidor_turno_id
    ]);

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'estado' => 'OK',
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
