<?php
header('Content-Type: application/json');
try {
    require_once '../conexion.php';
    include_once '../clases/TokenValidator.php';

    // Llama la validación antes de cualquier consulta
    $usuarioId = TokenValidator::validar($conn);

    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input) throw new Exception("JSON inválido.");

    $stmt = $conn->prepare("SELECT * FROM im_vale_combustible(
        :pid, :psurtidor_turno_id, :pcliente_id, :pnumero_vale,
        :pvolumen_galones, :pimporte_soles, :pobservacion,
        :pempresa_id, :psucursal_id
    )");

    $stmt->execute([
        ':pid' => $input['id'] ?? 0,
        ':psurtidor_turno_id' => $input['surtidor_turno_id'],
        ':pcliente_id' => $input['cliente_id'],
        ':pnumero_vale' => $input['numero_vale'],
        ':pvolumen_galones' => $input['volumen_galones'],
        ':pimporte_soles' => $input['importe_soles'],
        ':pobservacion' => $input['observacion'],
        ':pempresa_id' => $input['empresa_id'],
        ':psucursal_id' => $input['sucursal_id']
    ]);

    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'estado' => $data['estado'],
        'id' => $data['id'],
        'mensaje' => $data['mensaje']
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
