<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    $resultado = [
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "JSON inválido: " . json_last_error_msg()
    ];
    http_response_code(400);
    echo json_encode($resultado, JSON_PRETTY_PRINT);
    exit;
}

try {
    $conn->beginTransaction();

    $sql = "SELECT im_transportista(?, ?, ?, ?, ?, ?, ?) AS transportista_id";
    $stmt = $conn->prepare($sql);

    // Parámetros esperados del JSON
    $tipo_doc       = $datos["TipoDoc"] ?? 0;
    $doc_identidad  = $datos["DocIdentidad"] ?? '';
    $razon_social   = $datos["RazonSocial"] ?? '';
    $direccion      = $datos["Direccion"] ?? '';
    $empresa_id     = $datos["Id_Empresa"] ?? 0;
    $id_transportista = $datos["Id_Transportista"] ?? 0;
    $estado         = $datos["Estado"] ?? "NUEVO";

    // Enlazar parámetros
    $stmt->bindParam(1, $tipo_doc, PDO::PARAM_INT);
    $stmt->bindParam(2, $doc_identidad, PDO::PARAM_STR);
    $stmt->bindParam(3, $razon_social, PDO::PARAM_STR);
    $stmt->bindParam(4, $direccion, PDO::PARAM_STR);
    $stmt->bindParam(5, $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(6, $id_transportista, PDO::PARAM_INT);
    $stmt->bindParam(7, $estado, PDO::PARAM_STR);

    $stmt->execute();
    $fila = $stmt->fetch(PDO::FETCH_ASSOC);
    $transportista_id = $fila['transportista_id'] ?? 0;

    if ($estado === "NUEVO") {
        if ($transportista_id > 0) {
            $conn->commit();
            $resultado = [
                "ESTADO" => "1",
                "ID" => $transportista_id,
                "MENSAJE" => "LA INFORMACIÓN GUARDÓ CORRECTAMENTE"
            ];
        } else {
            $conn->rollBack();
            $resultado = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACIÓN"
            ];
        }
    } else {
        $conn->commit();
        $resultado = [
            "ESTADO" => "1",
            "ID" => $transportista_id,
            "MENSAJE" => "LA INFORMACIÓN ACTUALIZÓ CORRECTAMENTE"
        ];
    }

    http_response_code(200);
    echo json_encode($resultado, JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    $conn->rollBack();
    $resultado = [
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ];
    http_response_code(500);
    echo json_encode($resultado, JSON_PRETTY_PRINT);
} finally {
    $conn = null;
}
?>