<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    //file_put_contents('log_guiart.json', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    if ($data === null) {
        throw new Exception("JSON inválido: " . json_last_error_msg());
    }


    if (!isset($data['estado'])) {
        throw new Exception("Falta el campo 'estado'");
    }

    if (!is_array($data['detalle']) || !is_array($data['series'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Los campos detalle y series deben ser arrays.'
        ], JSON_UNESCAPED_UNICODE);
        http_response_code(400);
        exit();
    }

    foreach (['detalle', 'series'] as $arr) {
        if (!isset($data[$arr]) || !is_array($data[$arr])) {
            throw new Exception("El campo '$arr' debe ser un array.");
        }
    }

    $conn->beginTransaction();

    $sql = "SELECT procesar_guiaremision(
        :p_empresa_id, :p_sucursal_id, :p_docfiscal_id, :p_motivoguia_id, :p_nserie, :p_ndocumento,
        :p_fecha_emision, :p_fecha_traslado, :p_direccion_partida, :p_ubigeo_partida,
        :p_tipodoc_cliente, :p_ndoc_cliente, :p_razonsocial, :p_direccion_llegada,
        :p_ubigeo_llegada, :p_placa, :p_placa2, :p_marca, :p_nroinscripcion,
        :p_dniconductor, :p_nombreconductor, :p_apellidosconductor, :p_licencia,
        :p_tipodoc_transportista, :p_ndoc_transportista, :p_nombre_transportista,
        :p_afecto_igv, :p_porcentaje_igv, :p_igv, :p_afecto, :p_inafecto,
        :p_exonerado, :p_total, :p_afecta_kardex, :p_cliente_id, :p_unidadtransp_id,
        :p_conductor_id, :p_transportista_id, :p_remitente_id, :p_tipodoc_remitente,
        :p_ndoc_remitente, :p_nombre_remitente, :p_nroinscripcion2, :p_trasladado,
        :p_sededestino_id, :p_almdestino_id, :p_almacen_id, :p_observacion,
        :p_documento_referencial, :p_confvehicular, :p_scop, :p_idguia, :p_estado,
        :p_detalle, :p_series
    ) AS idguia";

    $stmt = $conn->prepare($sql);

    $campos = [
        'empresa_id', 'sucursal_id', 'docfiscal_id', 'motivoguia_id', 'nserie', 'ndocumento',
        'fecha_emision', 'fecha_traslado', 'direccion_partida', 'ubigeo_partida',
        'tipodoc_cliente', 'ndoc_cliente', 'razonsocial', 'direccion_llegada',
        'ubigeo_llegada', 'placa', 'placa2', 'marca', 'nroinscripcion',
        'dniconductor', 'nombreconductor', 'apellidosconductor', 'licencia',
        'tipodoc_transportista', 'ndoc_transportista', 'nombre_transportista',
        'afecto_igv', 'porcentaje_igv', 'igv', 'afecto', 'inafecto',
        'exonerado', 'total', 'afecta_kardex', 'cliente_id', 'unidadtransp_id',
        'conductor_id', 'transportista_id', 'remitente_id', 'tipodoc_remitente',
        'ndoc_remitente', 'nombre_remitente', 'nroinscripcion2', 'trasladado',
        'sededestino_id', 'almdestino_id', 'almacen_id', 'observacion',
        'documento_referencial', 'confvehicular', 'scop', 'idguia', 'estado'
    ];

    foreach ($campos as $campo) {
        $valor = $data[$campo] ?? null;
    
        // Convertir campos booleanos explícitamente
        if (in_array($campo, ['afecto_igv', 'afecta_kardex', 'trasladado'], true)) {
            $valor = filter_var($valor, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);
            $stmt->bindValue(":p_$campo", $valor, PDO::PARAM_BOOL);
        } else {
            $stmt->bindValue(":p_$campo", $valor);
        }
    }

    $stmt->bindValue(":p_detalle", json_encode($data['detalle']), PDO::PARAM_STR);
    $stmt->bindValue(":p_series", json_encode($data['series']), PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $id = $result['idguia'] ?? 0;

    $conn->commit();

    echo json_encode([
        "ESTADO" => $id > 0 ? "00" : "11",
        "ID" => $id,
        "MENSAJE" => $id > 0 ? "GUÍA PROCESADA CON ÉXITO" : "ERROR AL PROCESAR LA GUÍA"
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    echo json_encode([
        "ESTADO" => "11",
        "ID" => 0,
        "MENSAJE" => "ERROR: " . $e->getMessage(),
        "TRACE" => $e->getTraceAsString()
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} finally {
    $conn = null;
}
?>