<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST, GET, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-type: application/json; charset=utf-8");

// Se incluye la conexión a la base de datos
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// ✅ Validar Token antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$response = [];

try {
    // Iniciar conexión con PostgreSQL
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 1. Ejecutar la primera consulta (Listar_Doc_x_Enviar)
    $stmt = $conn->prepare("SELECT * FROM Listar_Doc_x_Enviar(?, ?, ?)");
    $stmt->bindParam(1, $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(2, $datos[1], PDO::PARAM_INT);
    $stmt->bindParam(3, $datos[2], PDO::PARAM_STR);
    $stmt->execute();
    
    $docEnviar = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $stmt->closeCursor();

    // Si hay documentos para enviar
    if (!empty($docEnviar)) {
        foreach ($docEnviar as &$doc) {
            $venta_id = $doc['id'];

            // 2. Obtener detalles de la venta (Listar_DetVenta)
            $stmt = $conn->prepare("SELECT * FROM Listar_DetVenta(?)");
            $stmt->bindParam(1, $venta_id, PDO::PARAM_INT);
            $stmt->execute();
            
            $doc['detVenta'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $stmt->closeCursor();

            // 3. Obtener cuotas de clientes
            $stmt = $conn->prepare("SELECT numero_cuota, importe, fecha_pago FROM cuotasclientes WHERE venta_id = ? ORDER BY numero_cuota ASC");
            $stmt->bindParam(1, $venta_id, PDO::PARAM_INT);
            $stmt->execute();
            
            $doc['cuotas'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $stmt->closeCursor();
        }
    }

    $response['docEnviar'] = $docEnviar;

} catch (PDOException $e) {
    // Capturar error y devolverlo en JSON
    $response['error'] = "ERROR: " . $e->getMessage();
}

// Cerrar conexión
$conn = null;

// Imprimir los datos como JSON
header("HTTP/1.1 200 OK");
echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
