<?php
error_reporting(E_ALL ^ E_NOTICE);
ini_set('display_errors', 1);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Error al decodificar JSON: " . json_last_error_msg());
    }

    // Validación del parámetro requerido
    if (!isset($datos['filtroTurno']) || !isset($datos['filtroCaja'])) {
        throw new Exception("Parámetros 'filtroTurno' y 'filtroCaja' requeridos.");
    }

    // Parámetro recibido
    $filtroTurno = $datos['filtroTurno'];
    $filtroCaja = $datos['filtroCaja'];

    // Llamada a la función PostgreSQL
    $sql = "SELECT liquidacion_empleado_turno_v2(:filtroTurno, :filtroCaja) AS resultado";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':filtroTurno', $filtroTurno, PDO::PARAM_STR);
    $stmt->bindParam(':filtroCaja', $filtroCaja, PDO::PARAM_STR);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row || !$row['resultado']) {
        throw new Exception("No se obtuvo respuesta de la función.");
    }

    echo $row['resultado']; // El contenido es un JSON válido

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "error" => "Error en la API: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
