<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 3) {
        throw new Exception("Faltan condiciones para los filtros WHERE y método");
    }

    $filtroInicial = $datos[0]; // Filtro antes del periodo
    $filtroFinal   = $datos[1]; // Filtro dentro del periodo
    $metodo        = strtoupper(trim($datos[2])); // 'PROMEDIO' o 'PEPS'

    // Llama a la función PostgreSQL
    $sql = "SELECT * FROM informe_kardex(:filtro_inicial, :filtro_final, :metodo)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':filtro_inicial', $filtroInicial, PDO::PARAM_STR);
    $stmt->bindParam(':filtro_final', $filtroFinal, PDO::PARAM_STR);
    $stmt->bindParam(':metodo', $metodo, PDO::PARAM_STR);
    $stmt->execute();

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($data ?: [], JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    error_response("Error en la base de datos: " . $e->getMessage());
} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
