<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

//ini_set('display_errors', 1);
//ini_set('log_errors', 1);
//ini_set('error_log', 'error_log.txt');

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    if ($data === null || json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode([
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => "JSON inválido: " . json_last_error_msg()
        ]);
        exit;
    }

    if (!isset($data['Estado'])) {
        throw new Exception("Falta el campo 'Estado'.");
    }

    $conn->beginTransaction();

    $sql = "SELECT procesar_notacred_clte(
        :p_empresa_id, :p_docfiscal_id, :p_nserie, :p_ndocumento,
        :p_fecha_emision, :p_fecha_traslado, :p_fecha_vencimiento,
        :p_razon_social, :p_direccion, :p_tipo_docidentidad, :p_docidentidad, :p_ndias,
        :p_moneda, :p_tipo_cambio, :p_afecto_igv, :p_pigv, :p_igv, :p_afecto_dscto, :p_pdscto, :p_descuento,
        :p_afecto_percepcion, :p_ppercepcion, :p_percepcion,
        :p_valor_venta, :p_inafecto, :p_exonerado, :p_total, :p_guia_remision,
        :p_cancelado, :p_icbper, :p_gratuitas, :p_afecta_kardex, :p_afecta_caja,
        :p_periodo, :p_mes, :p_formapago_id, :p_caja_id, :p_cliente_id,
        :p_empleado_id, :p_sucursal_id, :p_observacion, :p_motivo_nota_id,
        :p_docfiscal_ref, :p_nserie_ref, :p_ndocumento_ref, :p_fecha_referencial,
        :p_ventaref_id, :p_iidvta, :p_estado, :p_detalle::jsonb, :p_cuotas::jsonb
    ) AS id_nota";

    $stmt = $conn->prepare($sql);

    // Bind exacto en orden de la función
    $stmt->bindValue(':p_empresa_id', $data['Empresa_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docfiscal_id', $data['DocFiscal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_nserie', $data['NSerie']);
    $stmt->bindValue(':p_ndocumento', $data['NDocumento']);
    $stmt->bindValue(':p_fecha_emision', $data['Fecha_Emision']);
    $stmt->bindValue(':p_fecha_traslado', $data['Fecha_Traslado']);
    $stmt->bindValue(':p_fecha_vencimiento', $data['Fecha_Vcto']);
    $stmt->bindValue(':p_razon_social', $data['Razon_Social']);
    $stmt->bindValue(':p_direccion', $data['Direccion']);
    $stmt->bindValue(':p_tipo_docidentidad', $data['Tipo_Documento'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docidentidad', $data['DocIdentidad']);
    $stmt->bindValue(':p_ndias', $data['NDias'], PDO::PARAM_INT);
    $stmt->bindValue(':p_moneda', $data['Moneda']);
    $stmt->bindValue(':p_tipo_cambio', $data['Tipo_Cambio']);
    $stmt->bindValue(':p_afecto_igv', $data['Afecto_IGV'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pigv', $data['pIGV']);
    $stmt->bindValue(':p_igv', $data['IGV']);
    $stmt->bindValue(':p_afecto_dscto', $data['Afecto_Dscto'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pdscto', $data['pDSCTO']);
    $stmt->bindValue(':p_descuento', $data['Descuento']);
    $stmt->bindValue(':p_afecto_percepcion', $data['Afecto_Percepcion'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_ppercepcion', $data['pPercepcion']);
    $stmt->bindValue(':p_percepcion', $data['Percepcion']);
    $stmt->bindValue(':p_valor_venta', $data['Valor_Venta']);
    $stmt->bindValue(':p_inafecto', $data['Inafecto']);
    $stmt->bindValue(':p_exonerado', $data['Exonerada']);
    $stmt->bindValue(':p_total', $data['Total_Pagar']);
    $stmt->bindValue(':p_guia_remision', $data['NGuiaRemision']);
    $stmt->bindValue(':p_cancelado', $data['Cancelado'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_icbper', $data['ICBPER']);
    $stmt->bindValue(':p_gratuitas', $data['Gratuitas']);
    $stmt->bindValue(':p_afecta_kardex', $data['Afecta_Kardex'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_afecta_caja', $data['Afecta_Caja'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_periodo', (string)$data['Periodo']);
    $stmt->bindValue(':p_mes', $data['Mes']);
    $stmt->bindValue(':p_formapago_id', $data['Forma_Pago'], PDO::PARAM_INT);
    $stmt->bindValue(':p_caja_id', $data['Caja_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_cliente_id', $data['Cliente_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_empleado_id', $data['Empleado_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_sucursal_id', $data['Sucursal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_observacion', $data['Observacion']);
    $stmt->bindValue(':p_motivo_nota_id', $data['MotivoNota'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docfiscal_ref', $data['DocFiscal_Ref'], PDO::PARAM_INT);
    $stmt->bindValue(':p_nserie_ref', $data['NSerie_Ref']);
    $stmt->bindValue(':p_ndocumento_ref', $data['Documento_Ref']);
    $stmt->bindValue(':p_fecha_referencial', $data['Fecha_EmisionRef']);
    $stmt->bindValue(':p_ventaref_id', $data['Id_VtaRef'], PDO::PARAM_INT);
    $stmt->bindValue(':p_iidvta', $data['IdVta_M'], PDO::PARAM_INT);
    $stmt->bindValue(':p_estado', $data['Estado']);
    $stmt->bindValue(':p_detalle', json_encode($data['detalle']), PDO::PARAM_STR);
    $stmt->bindValue(':p_cuotas', json_encode($data['cuotas']), PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $idNota = $result['id_nota'];

    $conn->commit();

    echo json_encode([
        'ESTADO' => $idNota > 0 ? '1' : '0',
        'ID' => $idNota ?: 0,
        'MENSAJE' => $idNota > 0 ? 'NOTA PROCESADA CORRECTAMENTE' : 'ERROR AL REGISTRAR LA NOTA'
    ]);

} catch (PDOException $e) {
    $conn->rollBack();
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ]);
} finally {
    $conn = null;
}
