<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    responder_json(['error' => 'Malformed JSON: ' . json_last_error_msg()]);
    exit;
}

try {
    $compraId = $datos[0] ?? null;

    if (!$compraId) {
        responder_json(['error' => 'ID de compra no proporcionado']);
    }

    $sql = "SELECT obtener_detalle_compra(:compra_id) AS resultado";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':compra_id', $compraId, PDO::PARAM_INT);
    $stmt->execute();

    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$resultado) {
        error_log("⚠️ No se encontraron datos para la compra ID: $compraId");
        responder_json([]);
    }

    echo $resultado['resultado'];

} catch (PDOException $e) {
    responder_json(['error' => 'Error en la consulta: ' . $e->getMessage()]);
}

function responder_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}
?>
