<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Methods: GET, POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

try {
    // Autenticación del token
    $usuarioId = TokenValidator::validar($conn);

    // Leer y validar parámetros JSON
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 3) {
        throw new Exception("Parámetros inválidos: se requieren empresa_id, operacion_id y tipocuenta_id.");
    }

    list($empresa_id, $operacion_id, $tipocuenta_id) = $datos;

    // Consulta optimizada: SELECT 1 + fetchColumn()
    $sql = "SELECT 1 FROM relacionar_operacioncuenta 
            WHERE empresa_id = :empresa_id 
              AND operacion_id = :operacion_id 
              AND tipocuenta_id = :tipocuenta_id 
            LIMIT 1";

    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->bindValue(':operacion_id', $operacion_id, PDO::PARAM_INT);
    $stmt->bindValue(':tipocuenta_id', $tipocuenta_id, PDO::PARAM_INT);
    $stmt->execute();

    // Respuesta clara: existe = true/false
    $existe = $stmt->fetchColumn() ? true : false;

    echo json_encode(['existe' => $existe], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
