<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Conexión PDO a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar el JSON recibido
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    print_json(['error' => 'JSON inválido']);
    exit();
}

// Validar que se haya enviado un ID válido
if (!isset($datos[0]) || !filter_var($datos[0], FILTER_VALIDATE_INT)) {
    http_response_code(400);
    print_json(['error' => 'ID inválido o no proporcionado']);
    exit();
}

$id = (int) $datos[0];
$rows = [];

try {
    $sql = "SELECT * FROM consultar_operacion_id(:id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        error_log("⚠️ No se encontraron datos para la operación ID: $id");
        $rows = [];
    }

    print_json($rows);
} catch (PDOException $e) {
    error_log("❌ Error al ejecutar la consulta: " . $e->getMessage());
    http_response_code(500);
    print_json(['error' => 'Error en la consulta', 'detalle' => $e->getMessage()]);
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
}
?>
