<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Incluir archivo de conexión
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar JSON
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['ESTADO' => '0', 'MENSAJE' => '❌ JSON inválido']);
    exit();
}

// Validar parámetros esperados
if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
    http_response_code(400);
    echo json_encode(['ESTADO' => '0', 'MENSAJE' => '❌ Parámetros incompletos']);
    exit();
}

// Asignar y sanitizar parámetros
$p_nombre = trim($datos[0]);
$p_empresa_id = (int) $datos[1];
$p_idop = (int) $datos[2];
$p_estado = strtoupper(trim($datos[3]));

try {
    $sql = "SELECT im_operacion(:nombre, :empresa_id, :idop, :estado) AS id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':nombre', $p_nombre, PDO::PARAM_STR);
    $stmt->bindParam(':empresa_id', $p_empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':idop', $p_idop, PDO::PARAM_INT);
    $stmt->bindParam(':estado', $p_estado, PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $id = $result['id'];

    if ($id > 0) {
        $mensaje = ($p_estado === 'NUEVO') ? 'LA INFORMACIÓN SE GUARDÓ CORRECTAMENTE' : 'LA INFORMACIÓN SE ACTUALIZÓ CORRECTAMENTE';
        echo json_encode([
            'ESTADO' => '1',
            'ID' => $id,
            'MENSAJE' => '✅ ' . $mensaje
        ], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode([
            'ESTADO' => '0',
            'ID' => '0',
            'MENSAJE' => '❌ No se guardaron los datos'
        ], JSON_UNESCAPED_UNICODE);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'ESTADO' => '0',
        'ID' => '0',
        'MENSAJE' => '❌ Error en la base de datos: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
