<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la conexin desde cualquier origen
header("Access-Control-Allow-Origin: *");
// Permite la ejecucin de los mtodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

// Se incluye el archivo que contiene la clase genrica
include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");

// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

// Parmetros de paginacin
$pagina = isset($datos['pagina']) ? intval($datos['pagina']) : 1; // Pgina actual
$porPagina = 500; // Nmero de registros por pgina

// Clculo del offset para la paginacin
$offset = ($pagina - 1) * $porPagina;

$sql = "SELECT P.id, P.codigo_producto, P.nombre, C.nombre AS nomcategoria, M.nombre AS nommarca, Mo.nombre AS nommodelo, P.ult_pcompra, P.codigo_barras, P.codigo_sunat, P.peso FROM productos AS P
INNER JOIN categorias AS C ON C.id = P.categoria_id
INNER JOIN marcas AS M ON M.id = P.marca_id
INNER JOIN modelos AS Mo ON Mo.id = P.modelo_id
WHERE P.empresa_id = ? And P.nombre LIKE ? ORDER BY P.nombre LIMIT ?, ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("issi", $datos[0], $datos[1], $offset, $porPagina);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $rows = $result->fetch_all(MYSQLI_ASSOC);
} else {
    // No se encontraron registros
    $rows = [];
}

$stmt->close();

print_json($rows);

function print_json($data) {
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
}
?>

