<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    if ($data === null) {
        throw new Exception("JSON inválido: " . json_last_error_msg());
    }

    if (!isset($data['Estado'])) {
        throw new Exception("Falta el campo 'Estado'.");
    }

    if (!isset($data['detalle']) || !is_array($data['detalle'])) {
        throw new Exception("El campo 'detalle' es obligatorio y debe ser un array.");
    }

    $conn->beginTransaction();

    $sql = "SELECT procesar_proforma(
        :p_empresa_id, :p_docfiscal_id, :p_nserie, :p_ndocumento, :p_fecha_emision, :p_fecha_traslado, :p_fecha_vencimiento,
        :p_nombre, :p_direccion, :p_tipdocident, :p_docidentidad, :p_ndias, :p_moneda, :p_tipo_cambio,
        :p_afecto_igv, :p_pigv, :p_igv, :p_afecto_dscto, :p_pdscto, :p_descuento, :p_afecto_percepcion,
        :p_ppercepcion, :p_percepcion, :p_afecto, :p_inafecto, :p_exonerado, :p_total, :p_guia_remision,
        :p_cancelado, :p_icbp, :p_gratuitas, :p_afecta_kardex, :p_afecta_caja, :p_periodo, :p_mes,
        :p_forma_pago_id, :p_caja_id, :p_cliente_id, :p_empleado_id, :p_sucursal_id, :p_observacion,
        :p_idprof_m, :p_estado, :p_detalle
    ) AS id_proforma";

    $stmt = $conn->prepare($sql);

    $data['Observacion'] = $data['Observacion'] ?? '';

    // Manejo seguro de booleanos
    $bool = fn($v) => in_array($v, [true, "true", 1, "1"], true);

    // Asignar valores
    $stmt->bindValue(':p_empresa_id',     $data['Empresa_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docfiscal_id',   $data['DocFiscal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_nserie',         $data['NSerie'], PDO::PARAM_STR);
    $stmt->bindValue(':p_ndocumento',     $data['NDocumento'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_emision',  $data['Fecha_Emision'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_traslado', $data['Fecha_Traslado'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_vencimiento', $data['Fecha_Vcto'], PDO::PARAM_STR);
    $stmt->bindValue(':p_nombre',         $data['Razon_Social'], PDO::PARAM_STR);
    $stmt->bindValue(':p_direccion',      $data['Direccion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_tipdocident',    $data['Tipo_Documento'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docidentidad',   $data['DocIdentidad'], PDO::PARAM_STR);
    $stmt->bindValue(':p_ndias',          $data['NDias'], PDO::PARAM_INT);
    $stmt->bindValue(':p_moneda',         $data['Moneda'], PDO::PARAM_STR);
    $stmt->bindValue(':p_tipo_cambio',    $data['Tipo_Cambio'], PDO::PARAM_STR);

    $stmt->bindValue(':p_afecto_igv',         $bool($data['Afecto_IGV']), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pigv',               $data['pIGV'], PDO::PARAM_STR);
    $stmt->bindValue(':p_igv',                $data['IGV'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecto_dscto',       $bool($data['Afecto_Dscto']), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pdscto',             $data['pDSCTO'], PDO::PARAM_STR);
    $stmt->bindValue(':p_descuento',          $data['Descuento'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecto_percepcion',  $bool($data['Afecto_Percepcion']), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_ppercepcion',        $data['pPercepcion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_percepcion',         $data['Percepcion'], PDO::PARAM_STR);

    $stmt->bindValue(':p_afecto',       $data['Valor_Venta'], PDO::PARAM_STR);
    $stmt->bindValue(':p_inafecto',     $data['Inafecto'], PDO::PARAM_STR);
    $stmt->bindValue(':p_exonerado',    $data['Exonerada'], PDO::PARAM_STR);
    $stmt->bindValue(':p_total',        $data['Total_Pagar'], PDO::PARAM_STR);
    $stmt->bindValue(':p_guia_remision',$data['NGuiaRemision'], PDO::PARAM_STR);
    $stmt->bindValue(':p_cancelado',    $bool($data['Cancelado']), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_icbp',         $data['ICBPER'], PDO::PARAM_STR);
    $stmt->bindValue(':p_gratuitas',    $data['Gratuitas'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecta_kardex',$bool($data['Afecta_Kardex']), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_afecta_caja',  $bool($data['Afecta_Caja']), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_periodo',      $data['Periodo'], PDO::PARAM_STR);
    $stmt->bindValue(':p_mes',          $data['Mes'], PDO::PARAM_STR);
    $stmt->bindValue(':p_forma_pago_id',$data['Forma_Pago'], PDO::PARAM_INT);
    $stmt->bindValue(':p_caja_id',      $data['Caja_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_cliente_id',   $data['Cliente_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_empleado_id',  $data['Empleado_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_sucursal_id',  $data['Sucursal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_observacion',  $data['Observacion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_idprof_m',     $data['IdProf_M'], PDO::PARAM_INT);
    $stmt->bindValue(':p_estado',       $data['Estado'], PDO::PARAM_STR);
    $stmt->bindValue(':p_detalle',      json_encode($data['detalle']), PDO::PARAM_STR);

    // Ejecutar y obtener ID generado
    $stmt->execute();
    $idProforma = $stmt->fetchColumn();

    $conn->commit();

    echo json_encode([
        "ESTADO" => $idProforma > 0 ? "1" : "0",
        "ID" => $idProforma ?: 0,
        "MENSAJE" => $idProforma > 0 ? "LA PROFORMA SE PROCESÓ CORRECTAMENTE" : "ERROR AL PROCESAR LA PROFORMA"
    ], JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    $conn->rollBack();
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ]);
} finally {
    $conn = null;
}
?>