<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 2) {
        throw new Exception("Se requieren 2 parámetros: [empresa_id, documento_identidad].");
    }

    $empresaId = $datos[0];
    $documento = $datos[1];

    $sql = "SELECT documento_identidad FROM proveedores WHERE empresa_id = :empresa_id AND documento_identidad = :documento LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id', $empresaId, PDO::PARAM_INT);
    $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
