<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

// Conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Obtener el cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validación de datos
    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Se requieren los parámetros: nserie, docfiscal_id y usuario_id.");
    }

    $nserie = trim($datos[0]);
    $docfiscal_id = (int) $datos[1];
    $usuario_id = (int) $datos[2];

    // Consulta segura con parámetros
    //$sql = "SELECT nserie FROM series_sucursal WHERE nserie = '$datos[0]' And docfiscal_id = $datos[1] And sucursal_id = $datos[2] LIMIT 1";
    $sql = "SELECT nserie 
            FROM series_sucursal 
            WHERE nserie = :nserie 
              AND docfiscal_id = :docfiscal_id 
              AND usuario_id = :usuario_id 
            LIMIT 1";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':nserie', $nserie, PDO::PARAM_STR);
    $stmt->bindParam(':docfiscal_id', $docfiscal_id, PDO::PARAM_INT);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
?>