<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8"); // Asegurarse de que este encabezado se envíe antes de cualquier salida

// Se incluye el archivo que contiene la conexión a PostgreSQL
include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

$rows = array();

try {
    // Preparar la llamada a la función en PostgreSQL
    $sql = "SELECT cobranza_mensual AS total_cobranza FROM Cobranza_Mensual(:param1, :param2, :param3, :param4)"; // Asume que Cobranza_Mensual es una función en PostgreSQL
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':param1', $datos[0], PDO::PARAM_STR);
    $stmt->bindValue(':param2', $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':param3', $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':param4', $datos[3], PDO::PARAM_INT);
    $stmt->execute();

    // Obtener el resultado de la función
    if ($stmt->rowCount() > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $rows[] = $row;
        }
    } else {
        // Si no se encuentran registros, devolver un array vacío
        $rows[] = ["total_cobranza" => 0];
    }

} catch (PDOException $e) {
    error_response("Error al ejecutar la consulta: " . $e->getMessage());
}

// Cerrar la conexión a la base de datos
$conn = null;

// Imprimir la respuesta en formato JSON
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>