<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Incluir la conexión a la base de datos
include_once '../conexion.php';

try {
    // Obtener el cuerpo de la solicitud y decodificar JSON
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1], $datos[2])) {
        error_response("Datos incompletos");
    }

    $nombre = $datos[0];
    $password = $datos[1];
    $empresa_id = (int) $datos[2];

    // Consulta segura con `prepare()`
    $sql = "SELECT 
                U.id AS usuario_id, U.nombre AS usuario, U.password, U.perfil, 
                E.ruc, E.nombre, E.nombre_comercial, E.usuario_sol, E.password_sol,
                E.firma_certificado, E.tipo_proceso, E.token_id, E.token_clave, 
                E.tipo_contribuyente, E.tipo_rubro, E.rubro, E.partida_registral, 
                E.envio_automatico 
            FROM usuarios AS U 
            INNER JOIN empresas E ON U.empresa_id = E.id 
            WHERE U.nombre = :nombre AND U.password = :password 
                  AND U.activo = TRUE AND E.id = :empresa_id";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
    $stmt->bindParam(':password', $password, PDO::PARAM_STR);
    $stmt->bindParam(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Si no hay registros, devolver un array vacío
    print_json($rows);

} catch (PDOException $e) {
    error_response("Error en la base de datos: " . $e->getMessage());
}

/**
 * Imprime un JSON válido y maneja errores de codificación
 */
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error en la conversión a JSON: " . json_last_error_msg());
    }
}

/**
 * Envia una respuesta de error en formato JSON
 */
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
