<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar parámetros
if (!isset($datos[0], $datos[1])) {
    error_response("Parámetros insuficientes.");
}

$cfiltro = $datos[0];
$empresa_id = $datos[1];

try {
    $sql = "SELECT * FROM stock_precios(:cfiltro, :empresa_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':cfiltro', $cfiltro, PDO::PARAM_STR);
    $stmt->bindValue(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        error_log("⚠️ No se encontraron productos en stock.");
        success_response("No se encontraron productos en stock.", []);
    }

    success_response("Productos en stock encontrados.", $rows);

} catch (PDOException $e) {
    error_response("Error en la consulta: " . $e->getMessage());
} finally {
    $conn = null;
}

// ✅ Funciones de respuesta estándar
function success_response($mensaje, $data) {
    echo json_encode([
        'estado' => '00',
        'mensaje' => $mensaje,
        'data' => $data
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

function error_response($mensaje) {
    http_response_code(500);
    echo json_encode([
        'estado' => '99',
        'mensaje' => $mensaje,
        'data' => []
    ], JSON_UNESCAPED_UNICODE);
    exit();
}
