<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    // Preparar el procedimiento almacenado en PostgreSQL
    $sql = "CALL Upd_Kardex(?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);

    // Asignar parámetros
    $stmt->bindParam(1, $datos[0], PDO::PARAM_STR);
    $stmt->bindParam(2, $datos[1], PDO::PARAM_STR);
    $stmt->bindParam(3, $datos[2], PDO::PARAM_STR);
    $stmt->bindParam(4, $datos[3], PDO::PARAM_STR);
    $stmt->bindParam(5, $datos[4], PDO::PARAM_INT);
    $stmt->bindParam(6, $datos[5], PDO::PARAM_STR);
    $stmt->bindParam(7, $datos[6], PDO::PARAM_STR);

    // Ejecutar el procedimiento almacenado
    $stmt->execute();

    // Crear respuesta JSON
    $resultado = [
        "ESTADO" => ($datos[6] === "MODIFICAR") ? "1" : "0",
        "ID" => ($datos[6] === "MODIFICAR") ? strval($datos[5]) : "0",
        "MENSAJE" => ($datos[6] === "MODIFICAR") ? 
            "LA INFORMACIÓN SE ACTUALIZÓ CORRECTAMENTE" : 
            "ERROR AL GUARDAR LA INFORMACIÓN"
    ];

} catch (PDOException $e) {
    // Capturar errores y enviar respuesta en JSON
    $resultado = [
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ];
}

// Cerrar conexión
$conn = null;

// Devolver la respuesta en formato JSON
header("HTTP/1.1 200 OK");
header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>
