<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la conexión desde cualquier origen
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Incluir la conexión a PostgreSQL
include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$rows = [];

// Validar que se envíen los parámetros requeridos
if (!isset($datos[0]) || !isset($datos[1]) || !isset($datos[2]) || !isset($datos[3])) {
    error_response("Parámetros inválidos.");
}

try {
    // Llamada a la función en PostgreSQL
    $sql = "SELECT ventas_mensuales AS total_ventas FROM Ventas_Mensuales(:param1, :param2, :param3, :param4)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':param1', $datos[0], PDO::PARAM_STR);
    $stmt->bindParam(':param2', $datos[1], PDO::PARAM_STR);
    $stmt->bindParam(':param3', $datos[2], PDO::PARAM_INT);
    $stmt->bindParam(':param4', $datos[3], PDO::PARAM_INT);
    $stmt->execute();

    // Obtener los resultados
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rows[] = $row;
    }

    // Si no hay resultados, devolver un JSON con total_ventas = 0
    if (empty($rows)) {
        $rows[] = ["total_ventas" => 0];
    }

} catch (PDOException $e) {
    error_response("Error en la consulta: " . $e->getMessage());
}

// Cerrar la conexión
$conn = null;

// Devolver JSON correctamente formateado
echo json_encode($rows, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
exit();

/**
 * Función para responder con error en formato JSON
 */
function error_response($message) {
    http_response_code(500);
    echo json_encode(["error" => $message], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit();
}
?>
