<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// verifica_sesion_activa.php
include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$usuario_id = $datos[0];

$sql = "SELECT token FROM tokens_sesion WHERE id = :usuario_id AND token_api IS NOT NULL";

$stmt = $conn->prepare($sql);
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();

$result = $stmt->fetch(PDO::FETCH_ASSOC);

echo json_encode([
    "activo" => $result ? true : false,
    "token_api" => $result['token_api'] ?? null
]);
?>