<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token y obtener ID de usuario
$usuarioId = TokenValidator::validar($conn);

// Leer cuerpo JSON
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar formato JSON
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    print_json(['error' => 'JSON inválido']);
    exit();
}

// Validar cantidad de parámetros (esperamos 7 ahora)
if (count($datos) < 7) {
    http_response_code(400);
    print_json(['error' => 'Se requieren 7 parámetros']);
    exit();
}

try {
    // Preparar y ejecutar SELECT a la función
    $sql = "SELECT fn_vta_envresumen(?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        $datos[0], // ccodigo_sunat
        $datos[1], // crpta_sunat
        $datos[2], // chash_sunat
        $datos[3], // chash_cpe
        $datos[4], // cfecha
        $datos[5], // csucursal_id
        $datos[6]  // csigla
    ]);

    // Obtener el resultado (entero)
    $cantidadActualizada = $stmt->fetchColumn();

    print_json([
        'estado' => 'ok',
        'mensaje' => 'Actualización realizada correctamente',
        'actualizados' => (int)$cantidadActualizada
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    print_json([
        'estado' => 'error',
        'mensaje' => 'Error al ejecutar la función',
        'detalles' => $e->getMessage()
    ]);
    error_log("❌ Error SQL: " . $e->getMessage());
}

// Función utilitaria para imprimir JSON
function print_json($data) {
    header("Content-Type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE: break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded'; break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch'; break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found'; break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON'; break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters'; break;
        default:
            echo ' - Unknown JSON error'; break;
    }
}
?>