<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 10) {
        throw new Exception("Parámetros incompletos. Se requieren 10 valores.");
    }

    $sql = "SELECT registro_resumen_diario(
                :cnomarchivo, :cfecha, :cnenvio, :ctipoticket, :ccantdoc,
                :cticket, :ccorrelat, :cestado, :chash, :cempresa_id
            ) AS id_resumen";

    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':cnomarchivo', $datos[0], PDO::PARAM_STR);
    $stmt->bindValue(':cfecha',      $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':cnenvio',     $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':ctipoticket', $datos[3], PDO::PARAM_STR);
    $stmt->bindValue(':ccantdoc',    $datos[4], PDO::PARAM_INT);
    $stmt->bindValue(':cticket',     $datos[5], PDO::PARAM_STR);
    $stmt->bindValue(':ccorrelat',   $datos[6], PDO::PARAM_STR);
    $stmt->bindValue(':cestado',     $datos[7], PDO::PARAM_STR);
    $stmt->bindValue(':chash',       $datos[8], PDO::PARAM_STR);
    $stmt->bindValue(':cempresa_id', $datos[9], PDO::PARAM_INT);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result && isset($result['id_resumen']) && $result['id_resumen'] > 0) {
        $respuesta = [
            "ESTADO" => "1",
            "ID" => $result['id_resumen'],
            "MENSAJE" => "RESUMEN REGISTRADO CORRECTAMENTE"
        ];
    } else {
        $respuesta = [
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => "NO SE REGISTRÓ EL RESUMEN. VERIFIQUE DATOS."
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}