<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/../../conexion.php';
require_once __DIR__ . '/../../tcpdf/tcpdf.php';

header("Content-Type: application/pdf; charset=utf-8");

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
        throw new Exception("Parámetros incompletos.");
    }

    $fechaInicio = $datos[0];
    $fechaFin    = $datos[1];
    $empresaId   = (int) $datos[2];
    $sucursalId  = (int) $datos[3];

    $sql = "SELECT
                v.cliente_id,
                 substring(unaccent('unaccent',c.nombre),0,65) as nombre,
                SUM(v.descuento) AS total_descuento
            FROM ventas v
            INNER JOIN clientes c ON c.id = v.cliente_id
            WHERE v.descuento > 0
              AND v.fecha_emision BETWEEN :fecha_inicio AND :fecha_fin
              AND v.empresa_id = :empresa_id
              AND v.sucursal_id = :sucursal_id
            GROUP BY v.cliente_id, c.nombre
            ORDER BY c.nombre";

    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':fecha_inicio' => $fechaInicio,
        ':fecha_fin'    => $fechaFin,
        ':empresa_id'   => $empresaId,
        ':sucursal_id'  => $sucursalId
    ]);

    $descuentos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($descuentos)) {
        throw new Exception("No se encontraron descuentos registrados.");
    }

    // Crear PDF
    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetMargins(10, 10, 10);
    $pdf->SetAutoPageBreak(true, 10);
    $pdf->SetDisplayMode(100, 'SinglePage');
    $pdf->AddPage();

    $logo_path = '../../tcpdf/logos/10278514876.png';
    if (file_exists($logo_path)) {
        $pdf->Image($logo_path, '', '', 30, 15, '', '', 'T', false, 300, 'C', false, false, 0, false, false, false);
    }
    $pdf->Ln(18);

    // Cabecera
    $pdf->SetFont('helvetica', 'B', 14);
    $pdf->Cell(0, 10, 'REPORTE DE DESCUENTOS REALIZADOS POR CLIENTE', 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 10);
    $pdf->Cell(0, 7, "Del $fechaInicio al $fechaFin", 0, 1, 'C');
    $pdf->Ln(3);

    // Tabla
    $pdf->SetFillColor(5, 152, 172);       // Fondo celeste oscuro
    $pdf->SetTextColor(255, 255, 255);     // Letras blancas
    $pdf->SetDrawColor(0, 0, 0);           // Borde negro

    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell(15, 8, 'ID', 1, 0, 'C', true);
    $pdf->Cell(135, 8, 'Cliente', 1, 0, 'C', true);
    $pdf->Cell(40, 8, 'Descuento Total (S/)', 1, 1, 'C', true);

    $pdf->SetTextColor(0, 0, 0);

    $pdf->SetFont('helvetica', '', 9);

    $totalGeneral = 0;

    foreach ($descuentos as $row) {
        $pdf->Cell(15, 7, $row['cliente_id'], 1, 0, 'C');
        $pdf->Cell(135, 7, utf8_decode($row['nombre']), 1, 0, 'L');
        $pdf->Cell(40, 7, number_format($row['total_descuento'], 2), 1, 1, 'R');

        $totalGeneral += $row['total_descuento'];
    }
    // Línea vacía antes del total
    $pdf->Ln(2);

    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell(150, 8, 'TOTAL GENERAL', 1, 0, 'R');
    $pdf->Cell(40, 8, number_format($totalGeneral, 2), 1, 1, 'R');

    $pdf->Output('reporte_descuentos_clientes.pdf', 'I');

} catch (Exception $e) {
    error_log("ERROR: " . $e->getMessage());
    echo json_encode([
        "estado" => "0",
        "mensaje" => "❌ " . $e->getMessage()
    ]);
}
?>
