<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/../../conexion.php';
require_once __DIR__ . '/../../tcpdf/tcpdf.php';

header("Content-Type: application/pdf; charset=utf-8");

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
        throw new Exception("Parámetros incompletos.");
    }

    $fechaInicio = $datos[0];
    $fechaFin    = $datos[1];
    $empresaId   = (int) $datos[2];
    $sucursalId  = (int) $datos[3];

    $sql = "SELECT 
                lt.producto,
                p.nombre AS producto_nombre,
                SUM(lt.galones) AS total_galones,
                SUM(lt.monto_total) AS total_soles
            FROM public.lecturas_turno lt
            INNER JOIN productos p ON p.id = lt.producto
            WHERE lt.fecha_registro BETWEEN :fecha_inicio AND :fecha_fin::timestamp + time '23:59:00'
              AND lt.empresa_id = :empresa_id
              AND lt.sucursal_id = :sucursal_id
            GROUP BY lt.producto, p.nombre
            ORDER BY p.nombre";

    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':fecha_inicio' => $fechaInicio,
        ':fecha_fin'    => $fechaFin,
        ':empresa_id'   => $empresaId,
        ':sucursal_id'  => $sucursalId
    ]);
    $lecturas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($lecturas)) {
        throw new Exception("No se encontraron lecturas registradas en el rango indicado.");
    }

    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetMargins(10, 10, 10);
    $pdf->SetAutoPageBreak(true, 10);
    $pdf->SetDisplayMode(100, 'SinglePage');
    $pdf->AddPage();

    $logo_path = '../../tcpdf/logos/10278514876.png';
    if (file_exists($logo_path)) {
        $pdf->Image($logo_path, '', '', 30, 15, '', '', 'T', false, 300, 'C', false, false, 0, false, false, false);
    }
    $pdf->Ln(18);

    // Cabecera
    $pdf->SetFont('helvetica', 'B', 14);
    $pdf->Cell(0, 10, 'REPORTE DE GALONES VENDIDOS POR PRODUCTO', 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 10);
    $pdf->Cell(0, 6, "Del $fechaInicio al $fechaFin", 0, 1, 'C');
    $pdf->Ln(5);

    // Tabla
    $pdf->SetFillColor(5, 152, 172);       // Fondo celeste oscuro
    $pdf->SetTextColor(255, 255, 255);     // Letras blancas
    $pdf->SetDrawColor(0, 0, 0);           // Borde negro

    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell(100, 8, 'Producto', 1, 0, 'C', true);
    $pdf->Cell(40, 8, 'Total Galones', 1, 0, 'C', true);
    $pdf->Cell(50, 8, 'Total Soles (S/)', 1, 1, 'C', true);

    $pdf->SetTextColor(0, 0, 0);

    $pdf->SetFont('helvetica', '', 10);

    foreach ($lecturas as $row) {
        $pdf->Cell(100, 7, utf8_decode($row['producto_nombre']), 1, 0, 'L');
        $pdf->Cell(40, 7, number_format($row['total_galones'], 3), 1, 0, 'R');
        $pdf->Cell(50, 7, number_format($row['total_soles'], 2), 1, 1, 'R');
    }

    $pdf->Output('reporte_galones_vendidos.pdf', 'I');

} catch (Exception $e) {
    error_log("ERROR: " . $e->getMessage());
    echo json_encode([
        "estado" => "0",
        "mensaje" => "❌ " . $e->getMessage()
    ]);
}
?>
