<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 8) {
        throw new Exception("Se requieren 8 parámetros: placa, placa2, marca, inscripcion, inscripcion2, empresa_id, id_unidad, estado.");
    }

    // Preparar la llamada a la función PostgreSQL
    $sql = "SELECT * FROM im_undtransp(:placa, :placa2, :marca, :inscripcion, :inscripcion2, :empresa_id, :id_unidad, :estado)";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':placa',         $datos[0], PDO::PARAM_STR);
    $stmt->bindValue(':placa2',        $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':marca',         $datos[2], PDO::PARAM_STR);
    $stmt->bindValue(':inscripcion',   $datos[3], PDO::PARAM_STR);
    $stmt->bindValue(':inscripcion2',  $datos[4], PDO::PARAM_STR);
    $stmt->bindValue(':empresa_id',    $datos[5], PDO::PARAM_INT);
    $stmt->bindValue(':id_unidad',     $datos[6], PDO::PARAM_INT);
    $stmt->bindValue(':estado',        $datos[7], PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($datos[7] === "NUEVO") {
        if ($result && isset($result['id_undtransp']) && $result['id_undtransp'] > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "ID" => $result['id_undtransp'],
                "MENSAJE" => "LA INFORMACION SE GUARDO CORRECTAMENTE"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACION"
            ];
        }
    } else {
        $respuesta = [
            "ESTADO" => "1",
            "ID" => strval($datos[6]),
            "MENSAJE" => "LA INFORMACION SE ACTUALIZO CORRECTAMENTE"
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
?>
