<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

try {
    // Validar Token (si lo usas en todas las APIs)
    $usuarioId = TokenValidator::validar($conn);

    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0])) {
        throw new Exception("Parámetros insuficientes.");
    }

    $venta_id = (int)$datos[0];

    // Llamar a la función PostgreSQL
    $sql = "SELECT * FROM Canje_Items(:venta_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':venta_id', $venta_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "estado" => "00",
        "mensaje" => "OK",
        "data" => $rows
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "error" => "Error en la API",
        "mensaje" => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
?>