<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permitir la conexión desde cualquier origen
header("Access-Control-Allow-Origin: *");
// Permitir la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

// Incluir la conexión a la base de datos
include_once '../conexion.php';

// Leer el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Verificar si los datos son válidos
if (json_last_error() !== JSON_ERROR_NONE) {
    responder_json(['error' => 'Malformed JSON: ' . json_last_error_msg()]);
    exit;
}

// Inicializar la respuesta
$response = array();

// Consultar empleados
$response['empleados'] = consultarEmpleados($conn,$datos[3] ?? '', $datos[2] ?? '');

// Consultar docfiscales
$response['docfiscales'] = consultarDocFiscales($conn,$datos[4] ?? '', $datos[5] ?? '');

// Consultar detalles de venta
$response['detalles'] = consultarDetallesVenta($conn, $datos[0]);

// Consultar cuotas
$response['cuotas'] = consultarCuotas($conn, $datos[0]);

// Consultar series
$response['series'] = consultarSeries($conn, $datos[0], $datos[1] ?? '', $datos[2] ?? '');

// Cerrar la conexión a la base de datos
$conn->close();

// Devolver la respuesta como JSON
header("Content-Type: application/json; charset=utf-8");
echo json_encode($response, JSON_UNESCAPED_UNICODE);

// Función para consultar empleados
function consultarEmpleados($conn, $param3, $param2) {
    $sql = "SELECT * FROM empleados WHERE empresa_id = ? AND sucursal_id = ? AND perfil = 3 Order By nombre";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $param3, $param2);
    $stmt->execute();
    $result = $stmt->get_result();

    $empleados = array(); // Corregido
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $empleados[] = $row; // Corregido
        }
    }

    $stmt->close();
    return $empleados;
}

// Función para consultar DocFiscales
function consultarDocFiscales($conn, $param4, $param5) {
    $sql = "SELECT * FROM docfiscales WHERE clasificacion = ? OR clasificacion = ? Order By nombre";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $param4, $param5);
    $stmt->execute();
    $result = $stmt->get_result();

    $docfiscales = array(); // Corregido
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $docfiscales[] = $row; // Corregido
        }
    }

    $stmt->close();
    return $docfiscales;
}

// Función para consultar detalles de venta
function consultarDetallesVenta($conn, $ventaId) {
    $sql = "CALL Listar_DetVenta(?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $ventaId);
    $stmt->execute();
    $result = $stmt->get_result();

    $detalles = array();
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $detalles[] = $row;
        }
    }

    $stmt->close();
    return $detalles;
}

// Función para consultar cuotas
function consultarCuotas($conn, $ventaId) {
    $sql = "SELECT numero_cuota, importe, fecha_pago FROM cuotasclientes WHERE venta_id = ? ORDER BY venta_id, numero_cuota ASC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $ventaId);
    $stmt->execute();
    $result = $stmt->get_result();

    $cuotas = array();
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $cuotas[] = $row;
        }
    }

    $stmt->close();
    return $cuotas;
}

// Función para consultar series
function consultarSeries($conn, $ventaId, $param1, $param2) {
    $sql = "CALL Listar_SalidaSeries(?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("isi", $ventaId, $param1, $param2);
    $stmt->execute();
    $result = $stmt->get_result();

    $series = array();
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $series[] = $row;
        }
    }

    $stmt->close();
    return $series;
}

// Función para manejar errores y responder con JSON
function responder_json($data) {
    header("Content-Type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}
?>
