<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Error en el JSON recibido: ' . json_last_error_msg()
        ], JSON_UNESCAPED_UNICODE);
        http_response_code(400);
        exit();
    }

    if (!isset($data['Estado'])) {
        throw new Exception("Falta el campo 'Estado'.");
    }

    $conn->beginTransaction();  // 🔹 Iniciar transacción

    // Llamar a la función procesar_venta en PostgreSQL
    $sql = "SELECT procesar_venta(
                :p_empresa_id, :p_docfiscal_id, :p_nserie, :p_ndocumento, :p_fecha_emision, :p_fecha_traslado, :p_fecha_vencimiento,
                :p_nombre, :p_direccion, :p_tipodocident, :p_docidentidad, :p_ndias, :p_moneda, :p_tipo_cambio, :p_afecto_igv, 
                :p_pigv, :p_igv, :p_afecto_dscto, :p_pdscto, :p_descuento, :p_afecto_percepcion, :p_ppercepcion, :p_percepcion,
                :p_afecto, :p_inafecto, :p_exonerado, :p_total, :p_guia_remision, :p_cancelado, :p_icbp, :p_gratuitas, 
                :p_afecta_kardex, :p_afecta_caja, :p_periodo, :p_mes, :p_formapago_id, :p_caja_id, :p_cliente_id, 
                :p_empleado_id, :p_sucursal_id, :p_observacion, :p_acuenta, :p_servicio, :p_zona_id, :p_tipo_rubro, 
                :p_placa, :p_valor_ref, :p_idventa, :p_estado, :p_detalle, :p_cuotas, :p_series
            ) AS id_venta";

    $stmt = $conn->prepare($sql);

    // Asignar valores a los parámetros
    $stmt->bindValue(':p_empresa_id', $data['Empresa_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docfiscal_id', $data['DocFiscal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_nserie', $data['NSerie'], PDO::PARAM_STR);
    $stmt->bindValue(':p_ndocumento', $data['NDocumento'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_emision', $data['Fecha_Emision'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_traslado', $data['Fecha_Traslado'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_vencimiento', $data['Fecha_Vcto'], PDO::PARAM_STR);
    $stmt->bindValue(':p_nombre', $data['Razon_Social'], PDO::PARAM_STR);
    $stmt->bindValue(':p_direccion', $data['Direccion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_tipodocident', $data['Tipo_Documento'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docidentidad', $data['DocIdentidad'], PDO::PARAM_STR);
    $stmt->bindValue(':p_ndias', $data['NDias'], PDO::PARAM_INT);
    $stmt->bindValue(':p_moneda', $data['Moneda'], PDO::PARAM_STR);
    $stmt->bindValue(':p_tipo_cambio', $data['Tipo_Cambio'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecto_igv', $data['Afecto_IGV'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pigv', $data['pIGV'], PDO::PARAM_STR);
    $stmt->bindValue(':p_igv', $data['IGV'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecto_dscto', $data['Descuento'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pdscto', $data['pDSCTO'], PDO::PARAM_STR);
    $stmt->bindValue(':p_descuento', $data['Descuento'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecto_percepcion', $data['Afecto_Percepcion'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_ppercepcion', $data['pPercepcion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_percepcion', $data['Percepcion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecto', $data['Valor_Venta'], PDO::PARAM_STR);
    $stmt->bindValue(':p_inafecto', $data['Inafecto'], PDO::PARAM_STR);
    $stmt->bindValue(':p_exonerado', $data['Exonerada'], PDO::PARAM_STR);
    $stmt->bindValue(':p_total', $data['Total_Pagar'], PDO::PARAM_STR);
    $stmt->bindValue(':p_guia_remision', $data['NGuiaRemision'], PDO::PARAM_STR);
    $stmt->bindValue(':p_cancelado', $data['Cancelado'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_icbp', $data['ICBPER'], PDO::PARAM_STR);
    $stmt->bindValue(':p_gratuitas', $data['Gratuitas'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecta_kardex', $data['Afecta_Kardex'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_afecta_caja', $data['Afecta_Caja'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_periodo', $data['Periodo'], PDO::PARAM_STR);
    $stmt->bindValue(':p_mes', $data['Mes'], PDO::PARAM_STR);
    $stmt->bindValue(':p_formapago_id', $data['Forma_Pago'], PDO::PARAM_INT);
    $stmt->bindValue(':p_caja_id', $data['Caja_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_cliente_id', $data['Cliente_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_empleado_id', $data['Empleado_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_sucursal_id', $data['Sucursal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_observacion', $data['Observacion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_acuenta', $data['a_Cuenta'], PDO::PARAM_STR);
    $stmt->bindValue(':p_servicio', $data['Servicio'], PDO::PARAM_BOOL);
    $stmt->bindValue(':p_zona_id', $data['Zona_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_tipo_rubro', $data['TipoRubro'], PDO::PARAM_INT);
    $stmt->bindValue(':p_placa', $data['Placa'], PDO::PARAM_STR);
    $stmt->bindValue(':p_valor_ref', $data['ValorReferencial'], PDO::PARAM_STR);
    $stmt->bindValue(':p_idventa', $data['IdVta_M'], PDO::PARAM_INT);
    $stmt->bindValue(':p_estado', $data['Estado'], PDO::PARAM_STR);
    $stmt->bindValue(':p_detalle', json_encode($data['detalle']), PDO::PARAM_STR);
    $stmt->bindValue(':p_cuotas', json_encode($data['cuotas']), PDO::PARAM_STR);
    $stmt->bindValue(':p_series', json_encode($data['series']), PDO::PARAM_STR);

    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $idventa = $resultado['id_venta'];

    // Preparar la respuesta
    if ($idventa > 0) {
        $conn->commit();

        $respuesta = array(
            "ESTADO" => "1",
            "ID" => $idventa,
            "MENSAJE" => "LA VENTA SE PROCESÓ CORRECTAMENTE"
        );
    } else {
        $conn->rollBack();

        $respuesta = array(
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => "ERROR AL PROCESAR LA VENTA"
        );
    }

    echo json_encode($respuesta, JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    $conn->rollBack();

    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_PRETTY_PRINT);

} finally {
    $conn = null;
}
?>