<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

// Se incluye el archivo que contiene la clase genérica
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Obtener el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");

// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    // Manejar el error de JSON si la decodificación falla
    http_response_code(400); // Bad Request
    print_json(['error' => 'Invalid JSON']);
    exit();
}

// Validar y escapar los datos recibidos para evitar inyecciones SQL
if (!isset($datos[0]) || !is_numeric($datos[0]) || 
    !isset($datos[1]) || !is_string($datos[1]) ||
    !isset($datos[2]) || !is_string($datos[2]) ||
    !isset($datos[3]) || !is_numeric($datos[3])) {
    http_response_code(400); // Bad Request
    print_json(['error' => 'Invalid input']);
    exit();
}

$param1 = mysqli_real_escape_string($conn, $datos[0]);
$param2 = mysqli_real_escape_string($conn, $datos[1]);
$param3 = mysqli_real_escape_string($conn, $datos[2]);
$param4 = mysqli_real_escape_string($conn, $datos[3]);

// Preparar la consulta SQL de manera segura
$sql = "CALL Buscar_DocVenta('$param1', '$param2', '$param3', '$param4')";
$rows = array();

if ($result = mysqli_query($conn, $sql)) {
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $rows[] = $row;
        }
        mysqli_free_result($result);
    } else {
        // No se encontraron registros
        print_json([]);
    }
} else {
    // Manejo del error al ejecutar la consulta
    http_response_code(500); // Internal Server Error
    print_json(['error' => 'Query execution failed', 'details' => mysqli_error($conn)]);
    exit();
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Imprimir los resultados en formato JSON
print_json($rows);

function print_json($data) {
    header("Content-Type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            // No errors
            break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
            break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
            break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
            break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        default:
            echo ' - Unknown error';
            break;
    }
}
?>
